/*
* Copyright (C) 2008  Intel Corporation
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License, version 2.1, as published by the Free Software Foundation.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include <stdio.h>              
#include <stdlib.h>             
#include <stddef.h> 
#include <string.h> 
#include <signal.h> 
#include "DCSApi.h"
#include "PolicyApi.h"

void DCS_ReturnValue_handler(int ret)
{
	switch (ret)
	{
	case DCS_SUCCESS :
		printf("success\n");
		break;
	case DCS_NOT_SUPPORTED :
		printf("request is not supported\n");
		break;
	case DCS_REQUEST_DENIED:
		printf("request is denied\n");
		break;
	case DCS_MODULE_NOTEXIST:
		printf("request module does not exit\n");
		break;
	case DCS_EVENT_NOTEXIST:
		printf("request event does not exit\n");
		break;
	case DCS_FUNC_NOTEXIST:
		printf("request function does not exit\n");
		break;
	case DCS_FAIL_OPERATION:
		printf("operation failed\n");
		break;
	case DCS_CONNECTION_ABORT:
		printf("connection abort\n");
	default:
		break;
	}
}

int main(int argc, char *argv[])
{
	int ret = 0;
	int i=0;
	int use_sp = 0;
	int use_rp = 0;
	int use_gp=0;
	int use_dp=0;
	int set_group=0;
	int set_moduleid=0;
	int set_opid=0;
	int set_action=0;
	int use_timer=0;
	int use_save=0;
	int enable=0;
	char c0;

	/* Command line parsing */
	for (i=1; i< argc; i++) 
	{
		if (strcmp("-sp", argv[i]) == 0) {
			use_sp = 1;
		} 
		else if (strcmp("-rp", argv[i]) == 0) {
			use_rp = 1;
		} 
		else if (strcmp("-gp", argv[i]) == 0  ) {
			use_gp=1;
		}
		else if (strcmp("-dp", argv[i]) == 0  ) {
			use_dp=1;
		}
		else if (strcmp("-group", argv[i]) == 0 && i < argc - 1 ) {
			i++;
			set_group = atoi(argv[i]);
			printf("set_group=%d\n",set_group);
		}
		else if (strcmp("-moduleid", argv[i]) == 0 && i < argc - 1 ) {
			i++;
			set_moduleid = atoi(argv[i]);
			printf("set_moduleid=%d\n",set_moduleid);
		}
		else if (strcmp("-opid", argv[i]) == 0 && i < argc - 1 ) {
			i++;
			set_opid = atoi(argv[i]);
			printf("set_opid=%d\n",set_opid);
		}
		else if (strcmp("-action", argv[i]) == 0 && i < argc - 1 ) {
			i++;
			set_action = atoi(argv[i]);
			printf("set_action=%d\n",set_action);
		}
		else if (strcmp("-timer", argv[i]) == 0  ) {
			use_timer=1;
		}
		else if (strcmp("-save", argv[i]) == 0  ) {
			use_save=1;
		}
	}

	/*initialize the DCS*/
	ret = DCS_Initialize();
	DCS_ReturnValue_handler(ret);

	/*set default policy*/
	if(use_dp==1)
	{
		if(set_action==0)
		{
			ret=DCS_SetDefaultPolicy(DCS_POLICY_ALLOWED);

			printf("DCS_SetDefaultPolicy\n");
			DCS_ReturnValue_handler(ret);
		}

		if(set_action==1)
		{
			ret=DCS_SetDefaultPolicy(DCS_POLICY_REJECTED);

			printf("DCS_SetDefaultPolicy\n");
			DCS_ReturnValue_handler(ret);
		}
	}

	/*set one policy*/
	if(use_sp==1)
	{
		if((set_group==1)&&(set_action==0))
		{
			ret=DCS_SetPolicy( DCS_PARENT_GROUP, set_moduleid, set_opid, DCS_POLICY_ALLOWED);

			printf("DCS_SetPolicy\n");
			DCS_ReturnValue_handler(ret);
		}

		if((set_group==2)&&(set_action==0))
		{
			ret=DCS_SetPolicy( DCS_STUDENT_GROUP, set_moduleid, set_opid, DCS_POLICY_ALLOWED);

			printf("DCS_SetPolicy\n");
			DCS_ReturnValue_handler(ret);
		}

		if((set_group==1)&&(set_action==1))
		{
			ret=DCS_SetPolicy( DCS_PARENT_GROUP, set_moduleid, set_opid, DCS_POLICY_REJECTED);

			printf("DCS_SetPolicy\n");
			DCS_ReturnValue_handler(ret);
		}

		if((set_group==2)&&(set_action==1))
		{
			ret=DCS_SetPolicy( DCS_STUDENT_GROUP, set_moduleid, set_opid, DCS_POLICY_REJECTED);

			printf("DCS_SetPolicy\n");
			DCS_ReturnValue_handler(ret);
		}
	}

	/*remove one policy*/
	if(use_rp==1)
	{
		if(set_group==1)
		{
			ret=DCS_RemovePolicy(DCS_PARENT_GROUP, set_moduleid, set_opid);

			printf("DCS_RemovePolicy\n");
			DCS_ReturnValue_handler(ret);
		}

		if(set_group==2)
		{
			ret=DCS_RemovePolicy(DCS_STUDENT_GROUP, set_moduleid, set_opid);

			printf("DCS_RemovePolicy\n");
			DCS_ReturnValue_handler(ret);
		}
	}

	/*Get policy*/
	DCS_Policy_Access ACCESS;
	if(use_gp==1)
	{
		if(set_group==1)
		{
			ret=DCS_GetPolicy(DCS_PARENT_GROUP, set_moduleid, set_opid, &ACCESS);

			printf(" DCS_GetPolicy value is :%d\n", ACCESS);

			printf("DCS_GetPolicy\n");
			DCS_ReturnValue_handler(ret);
		}

		if(set_group==2)
		{
			ret=DCS_GetPolicy(DCS_STUDENT_GROUP, set_moduleid, set_opid, &ACCESS);

			printf(" DCS_GetPolicy value is :%d\n", ACCESS);

			printf("DCS_GetPolicy\n");
			DCS_ReturnValue_handler(ret);
		}
	}

	/*save policy*/
	if(use_save==1)
	{
		ret=DCS_SavePolicy();
		printf("DCS_SavePolicy\n");
		DCS_ReturnValue_handler(ret);

	}

	/*uninitialize the DCS*/
	ret=DCS_Uninitialize();
	DCS_ReturnValue_handler(ret);

	return 0;
}

